/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.concrete;

import com.minecolonies.api.colony.requestsystem.request.RequestState;
import com.minecolonies.api.colony.requestsystem.requestable.crafting.PublicCrafting;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingConcreteMixer;
import com.minecolonies.coremod.colony.jobs.JobConcreteMixer;
import com.minecolonies.coremod.entity.ai.basic.AbstractEntityAICrafting;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.ConcretePowderBlock;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class EntityAIConcreteMixer
extends AbstractEntityAICrafting<JobConcreteMixer, BuildingConcreteMixer> {
    private static final Predicate<ItemStack> CONCRETE = stack -> !stack.func_190926_b() && stack.func_77973_b() instanceof BlockItem && ((BlockItem)stack.func_77973_b()).func_179223_d() instanceof ConcretePowderBlock;

    public EntityAIConcreteMixer(@NotNull JobConcreteMixer job) {
        super(job);
    }

    @Override
    public Class<BuildingConcreteMixer> getExpectedBuildingClass() {
        return BuildingConcreteMixer.class;
    }

    @Override
    protected IAIState decide() {
        if (((JobConcreteMixer)this.job).getCurrentTask() == null) {
            return AIWorkerState.START_WORKING;
        }
        if (this.walkTo == null && this.walkToBuilding()) {
            return AIWorkerState.START_WORKING;
        }
        if (((JobConcreteMixer)this.job).getActionsDone() > 0) {
            return this.getState();
        }
        if (this.currentRequest != null && this.currentRecipeStorage != null) {
            return AIWorkerState.QUERY_ITEMS;
        }
        return AIWorkerState.GET_RECIPE;
    }

    @Override
    protected int getExtendedCount(ItemStack primaryOutput) {
        return ((BuildingConcreteMixer)this.getOwnBuilding()).outputBlockCountInWorld(primaryOutput);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private IAIState mixConcrete() {
        BlockPos pos;
        int slot = -1;
        if (this.currentRequest != null && this.currentRecipeStorage != null) {
            ItemStack inputStack = this.currentRecipeStorage.getCleanedInput().get(0).getItemStack();
            if (!CONCRETE.test(inputStack)) return AIWorkerState.START_WORKING;
            slot = InventoryUtils.findFirstSlotInItemHandlerWith((IItemHandler)this.worker.getInventoryCitizen(), s -> s.func_77969_a(inputStack));
        } else {
            slot = InventoryUtils.findFirstSlotInItemHandlerWith((IItemHandler)this.worker.getInventoryCitizen(), CONCRETE);
        }
        if (slot != -1) {
            ItemStack stack = this.worker.getInventoryCitizen().getStackInSlot(slot);
            Block block = ((BlockItem)stack.func_77973_b()).func_179223_d();
            BlockPos posToPlace = ((BuildingConcreteMixer)this.getOwnBuilding()).getBlockToPlace();
            if (posToPlace != null) {
                if (this.walkToBlock(posToPlace)) {
                    this.walkTo = posToPlace;
                    return AIWorkerState.START_WORKING;
                }
                this.walkTo = null;
                if (!InventoryUtils.attemptReduceStackInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), stack, 1)) return AIWorkerState.START_WORKING;
                this.world.func_180501_a(posToPlace, block.func_176223_P().func_196956_a(Direction.DOWN, block.func_176223_P(), (IWorld)this.world, posToPlace, posToPlace), 3);
                return AIWorkerState.START_WORKING;
            }
        }
        if ((pos = ((BuildingConcreteMixer)this.getOwnBuilding()).getBlockToMine()) != null) {
            if (this.walkToBlock(pos)) {
                this.walkTo = pos;
                return AIWorkerState.START_WORKING;
            }
            this.walkTo = null;
            if (!this.mineBlock(pos)) return AIWorkerState.START_WORKING;
            this.resetActionsDone();
            return AIWorkerState.CRAFT;
        }
        if (InventoryUtils.hasItemInItemHandler((IItemHandler)((BuildingConcreteMixer)this.getOwnBuilding()).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElseGet(null), CONCRETE)) {
            this.needsCurrently = new Tuple<Predicate<ItemStack>, Integer>(CONCRETE, 64);
            return AIWorkerState.GATHERING_REQUIRED_MATERIALS;
        }
        this.incrementActionsDone();
        return AIWorkerState.START_WORKING;
    }

    @Override
    protected IAIState craft() {
        if (this.currentRecipeStorage == null) {
            return AIWorkerState.START_WORKING;
        }
        if (this.currentRequest == null && ((JobConcreteMixer)this.job).getCurrentTask() != null) {
            return AIWorkerState.GET_RECIPE;
        }
        if (this.walkTo == null && this.walkToBuilding()) {
            return this.getState();
        }
        this.currentRequest = ((JobConcreteMixer)this.job).getCurrentTask();
        if (this.currentRequest != null && (this.currentRequest.getState() == RequestState.CANCELLED || this.currentRequest.getState() == RequestState.FAILED)) {
            this.currentRequest = null;
            this.incrementActionsDone(this.getActionRewardForCraftingSuccess());
            this.currentRecipeStorage = null;
            return AIWorkerState.START_WORKING;
        }
        ItemStack concrete = this.currentRecipeStorage.getPrimaryOutput();
        if (concrete.func_77973_b() instanceof BlockItem && ((BlockItem)concrete.func_77973_b()).func_179223_d() instanceof ConcretePowderBlock) {
            return super.craft();
        }
        IAIState mixState = this.mixConcrete();
        if (mixState == this.getState()) {
            this.currentRequest.addDelivery(new ItemStack((IItemProvider)concrete.func_77973_b(), 1));
            ((JobConcreteMixer)this.job).setCraftCounter(((JobConcreteMixer)this.job).getCraftCounter() + 1);
            if (((JobConcreteMixer)this.job).getCraftCounter() >= ((JobConcreteMixer)this.job).getMaxCraftingCount()) {
                this.incrementActionsDone(this.getActionRewardForCraftingSuccess());
                this.currentRecipeStorage = null;
                this.resetValues();
                if (this.inventoryNeedsDump() && ((JobConcreteMixer)this.job).getMaxCraftingCount() == 0 && ((JobConcreteMixer)this.job).getCraftCounter() == 0 && this.currentRequest != null) {
                    ((JobConcreteMixer)this.job).finishRequest(true);
                    this.worker.getCitizenExperienceHandler().addExperience((double)((PublicCrafting)this.currentRequest.getRequest()).getCount() / 2.0);
                }
            }
        }
        return mixState;
    }
}

